/**
 * SafeSvg Icon Block
 */

/**
 * WordPress dependencies
 */
import { __ } from '@wordpress/i18n';
import { registerBlockType } from '@wordpress/blocks';

/**
 * Internal dependencies
 */
import edit from './edit';
import save from './save';
import block from './block.json';

/* Uncomment for CSS overrides in the admin */
import './frontend.scss';

/**
 * Register block
 */
registerBlockType( block.name, {
	title: __( 'Inline SVG', 'safe-svg' ),
	description: __(
		'Display an SVG icon',
		'safe-svg'
	),
	edit,
	save,
	icon: {
		src: <svg xmlns='http://www.w3.org/2000/svg' width='800' height='800' viewBox='0 0 512 512'><path fill='currentColor' fill-rule='evenodd' d='M321.838 42.667H87.171v234.666h42.667v-192h174.293l81.707 81.707v110.293h42.667v-128L321.838 42.667ZM85.333 441.734l4.17-24.65c14.68 6.163 27.126 9.244 37.337 9.244 6.645 0 11.54-1.631 14.68-4.894 2.72-2.84 4.079-6.313 4.079-10.422 0-3.685-1.33-6.555-3.988-8.61-2.658-2.053-9.213-5.225-19.665-9.515-7.734-3.202-13.186-5.588-16.358-7.16-3.172-1.57-6.087-3.352-8.745-5.346-7.552-5.619-11.328-13.715-11.328-24.287 0-9.123 2.477-17.129 7.43-24.016 7.613-10.694 20.12-16.04 37.52-16.04 12.566 0 26.22 2.325 40.962 6.977l-5.8 23.563c-8.7-3.202-15.24-5.317-19.62-6.344-4.38-1.027-8.957-1.54-13.73-1.54-5.437 0-9.576 1.208-12.416 3.625-2.96 2.597-4.44 5.89-4.44 9.878 0 3.443 1.253 6.147 3.76 8.11 2.508 1.964 8.535 4.91 18.08 8.837 9.486 3.927 15.77 6.66 18.85 8.201a55.772 55.772 0 0 1 8.7 5.392c7.432 5.68 11.147 14.35 11.147 26.01 0 13.775-4.682 24.197-14.047 31.265-7.975 5.982-19.152 8.972-33.53 8.972-14.984 0-29.333-2.417-43.048-7.25Zm146.722 4.985L183.39 318.303h30.087l21.388 57.637c5.437 14.682 9.515 26.765 12.234 36.25 4.169-13.291 8.126-24.982 11.872-35.071l22.022-58.816h28.637l-48.665 128.416h-28.91ZM429.8 374.853v65.522c-7.37 2.477-12.567 4.108-15.588 4.894-9.364 2.477-19.424 3.715-30.178 3.715-21.146 0-37.247-5.317-48.303-15.95-12.264-11.72-18.397-28.063-18.397-49.028 0-24.106 7.613-42.292 22.838-54.556 11.056-8.942 25.979-13.413 44.769-13.413 16.07 0 31.024 2.93 44.859 8.79l-9.878 22.567c-6.525-3.263-12.235-5.544-17.128-6.843-4.894-1.299-10.271-1.948-16.132-1.948-14.016 0-24.347 4.561-30.993 13.684-5.619 7.734-8.428 17.914-8.428 30.54 0 15.165 4.229 26.584 12.687 34.257 6.767 6.163 15.165 9.244 25.194 9.244 5.86 0 11.419-.997 16.675-2.99v-25.829h-22.113v-22.656H429.8Z'></path></svg>
	}
} );
